/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.config;

import filenet.vw.apps.config.VWConfigMenuBar;
import filenet.vw.apps.config.VWConfigToolBar;
import filenet.vw.apps.config.images.VWImageLoader;
import filenet.vw.apps.config.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.IVWConfigActionListener;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigActionEvent;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigContextMenu;
import filenet.vw.toolkit.admin.VWConfigPerformer;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigRootNode;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.changes.VWConfigChangesPane;
import filenet.vw.toolkit.admin.content.VWConfigContentPane;
import filenet.vw.toolkit.admin.scope.VWConfigScopePane;
import filenet.vw.toolkit.utils.VWAboutHelper;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWBaseCore;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.event.EventListenerList;

public class VWConfigCore
extends VWBaseCore
implements ActionListener,
IVWConfigActionListener {
    private VWConfigToolBar m_toolBar = null;
    private VWConfigMenuBar m_menuBar = null;
    private Container m_mainContainer = null;
    private Container m_contentPane = null;
    private JRootPane m_rootPane = null;
    private VWSessionInfo m_sessionInfo = null;
    private VWSplitPane m_rootSplitPane = null;
    private int m_rootDividerLocation;
    private VWSplitPane m_viewSplitPane = null;
    private int m_viewDividerLocation;
    private boolean m_bViewScopePane = true;
    private boolean m_bViewStatusPane = true;
    private VWConfigRootNode m_consoleRoot = null;
    private VWConfigRootNode m_configData = null;
    private VWConfigBaseNode m_focus = null;
    private VWConfigScopePane m_vwScopePane = null;
    private VWConfigContentPane m_vwContentPane = null;
    private VWConfigChangesPane m_vwChangesPane = null;
    private EventListenerList m_listenerList = new EventListenerList();
    private VWConfigPerformer m_performer = null;
    private Vector m_modifiedNodes = null;
    private static final double s_defaultHSplitRatio = 0.25;
    private static final double s_defaultHSplitRatio_bidi = 0.7;

    public void init(VWSessionInfo sessionInfo) {
        try {
            this.m_mainContainer = sessionInfo.getParentContainer();
            this.m_sessionInfo = sessionInfo;
            String baseURL = sessionInfo.getProperty("baseURL");
            if (baseURL != null && baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            if (this.m_mainContainer instanceof JApplet) {
                this.m_rootPane = ((JApplet)this.m_mainContainer).getRootPane();
                this.m_contentPane = ((JApplet)this.m_mainContainer).getContentPane();
            } else if (this.m_mainContainer instanceof JFrame) {
                this.m_rootPane = ((JFrame)this.m_mainContainer).getRootPane();
                this.m_contentPane = ((JFrame)this.m_mainContainer).getContentPane();
            }
            RepaintManager repaintManager = RepaintManager.currentManager(this.m_mainContainer);
            if (!repaintManager.isDoubleBufferingEnabled()) {
                repaintManager.setDoubleBufferingEnabled(true);
            }
            super.init(sessionInfo);
            this.m_performer = new VWConfigPerformer(sessionInfo);
            this.m_contentPane.setLayout(new BorderLayout());
            this.initConsole(this.m_contentPane, baseURL);
            this.m_menuBar = new VWConfigMenuBar(this.m_mainContainer, this);
            this.m_rootPane.setJMenuBar(this.m_menuBar);
            this.m_toolBar = new VWConfigToolBar(this);
            this.m_contentPane.add((Component)this.m_toolBar, "First");
            super.performInitialRefresh();
            this.addConfigActionListener(this.m_vwContentPane);
            this.addConfigActionListener(this.m_vwScopePane);
            this.addConfigActionListener(this.m_toolBar);
            this.m_vwContentPane.addConfigActionListener(this);
            this.m_vwContentPane.addConfigActionListener(this.m_vwScopePane);
            this.m_vwContentPane.addConfigActionListener(this.m_toolBar);
            this.m_vwScopePane.addConfigActionListener(this);
            this.m_vwScopePane.addConfigActionListener(this.m_vwContentPane);
            this.m_vwScopePane.addConfigActionListener(this.m_toolBar);
            this.m_configData.addConfigStatusListener(this.m_vwChangesPane);
            this.m_configData.addConfigStatusListener(this.m_toolBar);
            this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
            this.m_toolBar.m_actionButton.requestFocus();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void destroy() {
        this.performExitItemAction(false);
    }

    public void addConfigActionListener(IVWConfigActionListener cal) {
        this.m_listenerList.add(IVWConfigActionListener.class, cal);
    }

    public void displayActionMenu(Component parent, int x, int y) {
        int nodeType = this.m_focus.getType();
        VWPopupMenu mi = null;
        switch (nodeType) {
            case 17: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 0, this, this.m_focus);
                ((VWConfigContextMenu)mi).setRootMenus((VWConfigRootNode)this.m_focus);
                break;
            }
            case 18: {
                VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)this.m_focus;
                if (sNode.activeRegionCount() <= 0) {
                    mi = new VWConfigContextMenu(this.m_vwSessionInfo, 18, this, this.m_focus);
                    break;
                }
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 1, this, this.m_focus);
                ((VWConfigContextMenu)mi).setSystemMenus((VWConfigVWServiceNode)this.m_focus);
                break;
            }
            case 19: {
                VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus;
                if (rNode.getSessionInfo() == null) {
                    mi = new VWConfigContextMenu(this.m_vwSessionInfo, 5, this, this.m_focus);
                    break;
                }
                mi = new VWConfigContextMenu(rNode.getSessionInfo(), 2, this, this.m_focus);
                ((VWConfigContextMenu)mi).setRegionMenus((VWConfigRegionNode)this.m_focus);
                break;
            }
            case 24: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 6, this, this.m_focus);
                break;
            }
            case 20: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 7, this, this.m_focus);
                break;
            }
            case 21: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 8, this, this.m_focus);
                break;
            }
            case 22: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 9, this, this.m_focus);
                break;
            }
            case 23: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 10, this, this.m_focus);
                break;
            }
            case 25: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 11, this, this.m_focus);
                break;
            }
            case 16: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 17, this, this.m_focus);
                break;
            }
            case 5: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 12, this, this.m_focus);
                break;
            }
            case 1: 
            case 2: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 13, this, this.m_focus);
                break;
            }
            case 3: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 14, this, this.m_focus);
                break;
            }
            case 4: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 15, this, this.m_focus);
                break;
            }
            case 6: {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 16, this, this.m_focus);
            }
        }
        if (mi != null) {
            mi.show(parent, x, y);
        }
    }

    public void displayViewMenu(Component parent, int x, int y) {
        VWConfigContextMenu mi = new VWConfigContextMenu(this.m_vwSessionInfo, 20, this, this.m_focus);
        mi.setViewMenus(this.m_bViewScopePane, this.m_bViewStatusPane);
        mi.show(parent, x, y);
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        Object aObj = event.getSource();
        try {
            if (VWStringUtils.compare(actionCMD, VWResource.Action) == 0) {
                JButton aButton = (JButton)aObj;
                this.displayActionMenu(aButton, 0, aButton.getHeight());
            } else if (VWStringUtils.compare(actionCMD, VWResource.View) == 0) {
                JButton aButton = (JButton)aObj;
                this.displayViewMenu(aButton, 0, aButton.getHeight());
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_EXIT) == 0) {
                this.performExitItemAction(true);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_LOGOFF) == 0) {
                this.performLogoffItemAction();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_LOGON) == 0) {
                if (this.m_performer.performLogon(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 96));
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_APPSPACE_PROPERTIES) == 0) {
                this.m_performer.performAppSpaceProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMMIT) == 0) {
                if (this.m_performer.performCommit(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                }
                this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMPONENT_PROPERTIES) == 0) {
                this.m_performer.performComponentQueueProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMPONENT_REGISTRATION) == 0) {
                this.m_performer.performComponentRegistration(this.m_focus);
                this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_CREATE_XLIFF_FILE) == 0) {
                this.m_performer.performCreateXliffFile(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_DELETE) == 0) {
                VWConfigBaseNode newFocusNode = this.m_performer.performDeleteItem(this.m_focus);
                if (newFocusNode != null) {
                    this.m_focus = newFocusNode;
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_DISCARD) == 0) {
                this.performDiscardItemAction();
                this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_EVENTLOG_PROPERTIES) == 0) {
                this.m_performer.performEventLogProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_EXPORT) == 0) {
                this.m_performer.performExport(this.m_focus);
                this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_IMPORT) == 0) {
                this.m_performer.performImport(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_INITIALIZE_REGION) == 0) {
                this.m_performer.performInitRegion(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_APPSPACE) == 0) {
                this.m_performer.performNewAppSpace(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_COMPONENT) == 0) {
                this.m_performer.performNewComponent(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_EVENTLOG) == 0) {
                this.m_performer.performNewEventLog(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_QUEUE) == 0) {
                this.m_performer.performNewQueue(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_ROSTER) == 0) {
                this.m_performer.performNewRoster(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_PUBLISH_UDDI) == 0) {
                this.m_performer.performPublishToUDDI(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_PUBLISH_WSRR) == 0) {
                this.m_performer.performPublishToWSRR(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_QUEUE_PROPERTIES) == 0) {
                this.m_performer.performQueueProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REFRESH) == 0) {
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                switch (this.m_focus.getType()) {
                    case 17: {
                        this.m_consoleRoot.refresh();
                        break;
                    }
                    case 18: {
                        VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)this.m_focus;
                        sNode.refresh();
                        break;
                    }
                    case 19: {
                        VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus;
                        rNode.refresh(true);
                        break;
                    }
                    default: {
                        VWConfigRegionNode rgNode = (VWConfigRegionNode)this.m_focus.findAncestorNode(19);
                        if (rgNode == null) break;
                        rgNode.refresh(true);
                        this.m_focus = rgNode;
                    }
                }
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 176));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REGION_PROPERTIES) == 0) {
                this.m_performer.performRegionProperties(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REMOVE_ALL_REGIONS) == 0) {
                if (this.m_performer.performRemoveAllRegions(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REMOVE_REGION) == 0) {
                if (this.m_performer.performRemoveRegion(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REMOVE_WORKFLOW_DATABASE) == 0) {
                this.m_performer.performRemoveWorkflowDataBase(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_ROSTER_PROPERTIES) == 0) {
                this.m_performer.performRosterProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_SYSTEM_PROPERTIES) == 0) {
                this.m_performer.performVWServiceProperties(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_UP) == 0) {
                this.performUpButtonAction();
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_VERIFY_XLIFF_FILE) == 0) {
                this.m_performer.performVerifyXliffFile(this.m_focus);
                this.m_toolBar.m_actionButton.requestFocus();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_ABOUT) == 0) {
                this.performAboutItemAction();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_HELP) == 0) {
                this.m_performer.performHelp(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_HELP_TOPICS) == 0) {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc012.htm");
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_ICON_VIEW) == 0) {
                this.performIconViewItemAction();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_PENDING_CHANGES) == 0) {
                this.performPendingChangesItemAction();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_PROPERTY_VIEW) == 0) {
                this.performPropertyViewItemAction();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_SCOPE_PANE) == 0) {
                this.performScopePaneItemAction();
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void configActionPerformed(VWConfigActionEvent evt) {
        VWConfigBaseNode baseNode = evt.getBaseNode();
        try {
            if (evt.changedFocus() && this.m_focus != baseNode) {
                this.m_focus = baseNode;
                this.m_toolBar.setToolBar(this.m_focus);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performRefreshItemAction() {
        this.m_vwContentPane.refreshContent();
    }

    protected void performScopePaneItemAction() {
        if (!this.m_bViewScopePane) {
            this.m_rootSplitPane.setDividerLocation(this.m_rootDividerLocation);
            this.m_bViewScopePane = true;
        } else {
            this.m_rootDividerLocation = this.m_rootSplitPane.getDividerLocation();
            this.m_rootSplitPane.setDividerLocation(0);
            this.m_bViewScopePane = false;
        }
    }

    protected void performPendingChangesItemAction() {
        if (!this.m_bViewStatusPane) {
            this.m_viewSplitPane.setDividerLocation(this.m_viewDividerLocation);
            this.m_bViewStatusPane = true;
        } else {
            this.m_viewDividerLocation = this.m_viewSplitPane.getDividerLocation();
            this.m_viewSplitPane.setDividerLocation(this.m_viewSplitPane.getHeight());
            this.m_bViewStatusPane = false;
        }
    }

    protected void performIconViewItemAction() {
        this.m_toolBar.m_iconViewButton.setEnabled(false);
        this.m_toolBar.m_propertyViewButton.setEnabled(true);
        this.m_vwContentPane.setViewMode(this.m_focus, 0);
    }

    protected void performPropertyViewItemAction() {
        this.m_toolBar.m_iconViewButton.setEnabled(true);
        this.m_toolBar.m_propertyViewButton.setEnabled(false);
        this.m_vwContentPane.setViewMode(this.m_focus, 1);
    }

    protected void performExitItemAction(boolean bCloseWindow) {
        try {
            if (this.m_consoleRoot == null) {
                return;
            }
            int rootChildCount = this.m_consoleRoot.getChildCount();
            for (int i = 0; i < rootChildCount; ++i) {
                VWConfigVWServiceNode serviceNode = (VWConfigVWServiceNode)this.m_consoleRoot.getChildAt(i);
                if (serviceNode == null) continue;
                int serviceChildCount = serviceNode.getChildCount();
                for (int j = 0; j < serviceChildCount; ++j) {
                    VWConfigRegionNode regionNode = (VWConfigRegionNode)serviceNode.getChildAt(j);
                    if (regionNode.getSessionInfo() == null || this.m_performer.performLogoff(regionNode, bCloseWindow)) continue;
                    return;
                }
            }
            this.releaseResources();
            if (!bCloseWindow) {
                return;
            }
            if (this.m_mainContainer != null && this.m_mainContainer instanceof JFrame) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JFrame)this.m_mainContainer, 201));
            } else if (this.m_mainContainer != null && this.m_mainContainer instanceof VWBaseAppLauncherApplet) {
                ((VWBaseAppLauncherApplet)this.m_mainContainer).closeWindow();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performDiscardItemAction() {
        int nodeType = this.m_focus.getType();
        if (nodeType != 17 && nodeType != 18 && nodeType != 19) {
            VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus.findAncestorNode(19);
            if (this.m_performer.performDiscard(rNode, true, true) == 0) {
                this.m_focus = rNode;
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
            }
        } else {
            this.m_performer.performDiscard(this.m_focus, true, true);
        }
        this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
    }

    protected void performLogoffItemAction() {
        int nodeType = this.m_focus.getType();
        VWConfigRegionNode rNode = null;
        switch (nodeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                rNode = (VWConfigRegionNode)this.m_focus.findAncestorNode(19);
                break;
            }
            case 19: {
                rNode = (VWConfigRegionNode)this.m_focus;
                break;
            }
        }
        if (this.m_performer.performLogoff(rNode, true)) {
            this.fireConfigActionEvent(new VWConfigActionEvent(this, rNode, 32));
            this.m_focus = (VWConfigBaseNode)rNode.getParent();
            this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
        }
    }

    protected void performAboutItemAction() {
        try {
            ImageIcon icon = VWImageLoader.createImageIcon("Config_3D_32.gif");
            String productName = VWIDMBaseFactory.instance().getVWString(4).toString();
            VWAboutHelper aboutBox = new VWAboutHelper(this.m_vwSessionInfo.getParentFrame(), productName, icon, this.m_vwSessionInfo);
            aboutBox.display();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performUpButtonAction() {
        VWConfigBaseNode aNode = (VWConfigBaseNode)this.m_focus.getParent();
        if (aNode != null) {
            this.m_focus = aNode;
            this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
        }
        if (this.m_focus.getParent() == null) {
            this.m_toolBar.m_upButton.setEnabled(false);
        }
    }

    protected void fireConfigActionEvent(VWConfigActionEvent evt) {
        if (evt == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWConfigActionListener.class) continue;
            ((IVWConfigActionListener)listeners[i + 1]).configActionPerformed(evt);
        }
    }

    protected void releaseResources() {
        if (this.m_toolBar != null) {
            this.m_toolBar.releaseResources();
            this.m_toolBar = null;
        }
        if (this.m_menuBar != null) {
            this.m_menuBar.releaseResources();
            this.m_menuBar = null;
        }
        if (this.m_rootSplitPane != null) {
            this.m_rootSplitPane.removeAll();
            this.m_rootSplitPane = null;
        }
        if (this.m_viewSplitPane != null) {
            this.m_viewSplitPane.removeAll();
            this.m_viewSplitPane = null;
        }
        if (this.m_consoleRoot != null) {
            this.m_consoleRoot.releaseResources();
            this.m_consoleRoot = null;
            this.m_configData = null;
        }
        if (this.m_vwScopePane != null) {
            this.m_vwScopePane.releaseResources();
            this.m_vwScopePane = null;
        }
        if (this.m_vwContentPane != null) {
            this.m_vwContentPane.releaseResources();
            this.m_vwContentPane = null;
        }
        if (this.m_vwChangesPane != null) {
            this.m_vwChangesPane.releaseResources();
            this.m_vwChangesPane = null;
        }
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWConfigActionListener.class, (IVWConfigActionListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        if (this.m_performer != null) {
            this.m_performer.releaseResources();
            this.m_performer = null;
        }
        if (this.m_modifiedNodes != null) {
            this.m_modifiedNodes.removeAllElements();
            this.m_modifiedNodes = null;
        }
        if (this.m_mainContainer != null && !(this.m_mainContainer instanceof VWBaseAppLauncherApplet)) {
            if (this.m_rootPane != null) {
                this.m_rootPane.removeAll();
            }
            if (this.m_mainContainer != null) {
                this.m_mainContainer.removeAll();
            }
        }
        if (this.m_contentPane != null) {
            this.m_contentPane.removeAll();
            this.m_contentPane = null;
        }
        this.m_rootPane = null;
        this.m_focus = null;
        super.releaseResources();
    }

    private void initConsole(Container contentPane, String baseURL) {
        try {
            this.m_modifiedNodes = new Vector();
            this.m_consoleRoot = new VWConfigRootNode(baseURL);
            this.m_consoleRoot.setupIsolatedRegions(this.m_vwSessionInfo);
            this.m_consoleRoot.setModifiedNodeList(this.m_modifiedNodes);
            this.m_configData = this.m_consoleRoot;
            this.m_focus = this.m_consoleRoot;
            this.m_vwChangesPane = new VWConfigChangesPane(this.m_modifiedNodes);
            this.m_vwScopePane = new VWConfigScopePane();
            this.m_vwScopePane.init(this.m_consoleRoot, this.m_performer);
            this.m_vwContentPane = new VWConfigContentPane();
            this.m_vwContentPane.init(this.m_consoleRoot, 0, this.m_performer);
            this.m_viewSplitPane = new VWSplitPane(0, this.m_vwContentPane, this.m_vwChangesPane);
            this.m_viewSplitPane.setToolTipText(VWResource.SlideToAdjustView);
            this.m_viewSplitPane.setOneTouchExpandable(true);
            this.m_viewSplitPane.setDividerSize(6);
            this.m_viewSplitPane.setDividerLocation(0.7);
            Locale browserLocale = this.m_sessionInfo.getBrowserLocale();
            ComponentOrientation compOrientation = null;
            compOrientation = browserLocale != null ? ComponentOrientation.getOrientation(browserLocale) : ComponentOrientation.getOrientation(Locale.getDefault());
            if (compOrientation.isLeftToRight()) {
                this.m_rootSplitPane = new VWSplitPane(1, this.m_vwScopePane.getConfigScopeViewPane(), this.m_viewSplitPane);
                this.m_rootSplitPane.setDividerLocation(0.25);
                if (this.m_rootSplitPane.getLeftComponent() instanceof JComponent) {
                    ((JComponent)this.m_rootSplitPane.getLeftComponent()).setDoubleBuffered(true);
                }
            } else {
                this.m_rootSplitPane = new VWSplitPane(1, this.m_viewSplitPane, this.m_vwScopePane.getConfigScopeViewPane());
                this.m_rootSplitPane.setDividerLocation(0.7);
                if (this.m_rootSplitPane.getRightComponent() instanceof JComponent) {
                    ((JComponent)this.m_rootSplitPane.getRightComponent()).setDoubleBuffered(true);
                }
            }
            this.m_rootSplitPane.setToolTipText(VWResource.SlideToAdjustView);
            this.m_rootSplitPane.setOneTouchExpandable(true);
            this.m_rootSplitPane.setDividerSize(6);
            contentPane.add((Component)this.m_rootSplitPane, "Center");
            contentPane.applyComponentOrientation(compOrientation);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

